#pragma once
#include "Level.h"

//MainGame is 1-1 itself, all items, enemies and gameplay take place within this level. In future, it may be wise to rename this to 1-1 if more levels are added

class MainGame :
	public Level
{
public:
	MainGame(sf::RenderWindow* hwnd, Input* input);
	~MainGame();

private:

	void reset();	//Automatically resets the level and Mario back to its initial load state
	//				this makes more sense than a destructor as we don't want to keep having to create new instances and reloading the tile map every time we die

	void update(float dt);
	void handleInput(float dt);
	void render();
};

